function [RND,RNDc] = LWM_RND_PDF(parm,M1,M2, xval,TTM)
%==========================================================================================
%The function computes the PDF and derivatives of the LWM_RND for a particular
%choice of parameter vector evaluated at xval with TTM denoting the time to maturity.
%
%INPUT:
%   parm: 3(M1+M2)-by-1 vector of estimated parameters (full version)
%   M1: number of Lognormal densities in the mixture
%   M2: number of Weibull densities in the mixture
%   xval: points to evaluate the pdf and the derivatives of the LWM
%         density, must be a column vector
%   TTM: time to maturity of the options (in years)
%
%OUTPUT:
%      RND: the PDF of LWM_RND evaluated at xval
%     RNDc: the mixture-wise PDF of LWM_RND
%==========================================================================================
% This ver: 2023/05/24
% Authors: Yifan Li (yifan.li@manchester.ac.uk)
%          Ingmar Nolte (i.nolte@lancaster.ac.uk)
%          Manh Pham (m.c.pham@lancaster.ac.uk)
% Reference: Li, Y., Nolte, I., and Pham, M. C. (2023). Parametric Risk-Neutral 
%          Density Estimation via Finite Lognormal-Weibull Mixtures
%========================================================================================== 


M=M1+M2;
w_vec = parm(1:M);
f_vec = parm(M+1:2*M);
sigma = parm(2*M+1:end);

%separate BS and WB parameters
f_vec1 = f_vec(1:M1);
sigma1 = sigma(1:M1);

f_vec2 = f_vec(M1+1:end);
sigma2 = sigma(M1+1:end);
if M1>0
    LNc = LN_density(xval,f_vec1',sigma1'*sqrt(TTM));
else
    LNc=[];
end
if M2>0
    WBc = WB_density(xval,f_vec2',sigma2');
else
    WBc = [];
end
RNDc = [LNc WBc].*w_vec';
RND = sum(RNDc,2);


end

